<?php
/**
 * Blog entry audio format media
 *
 * @package Total WordPress theme
 * @subpackage Partials
 * @version 4.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Display media
if ( apply_filters( 'wpex_blog_entry_audio_embed', wpex_get_mod( 'blog_entry_audio_output', false ) )
	&& ! post_password_required()
	&& $audio = wpex_get_post_audio_html()
) : ?>

	<div class="blog-entry-media entry-media wpex-clr"><?php echo $audio; ?></div>

<?php
// Display media if thumbnail exists
elseif ( $thumbnail = wpex_get_blog_entry_thumbnail() ) :

	// Overlay style
	$overlay = wpex_get_mod( 'blog_entry_overlay' );
	$overlay = $overlay ? $overlay : 'none'; ?>

	<div class="blog-entry-media entry-media wpex-clr <?php echo wpex_overlay_classes( $overlay ); ?>">
		<a href="<?php wpex_permalink(); ?>" title="<?php wpex_esc_title(); ?>" rel="bookmark" class="blog-entry-media-link<?php wpex_entry_image_animation_classes(); ?>">
			<?php echo $thumbnail; ?>
			<?php if ( $overlay && 'none' != $overlay ) { ?>
				<?php wpex_overlay( 'inside_link', $overlay ); ?>
			<?php } elseif ( ! wpex_get_mod( 'thumbnail_format_icons' ) ) { ?>
				<div class="blog-entry-music-icon-overlay"><span class="ticon ticon-music"></span></div>
			<?php } ?>
			<?php wpex_entry_media_after( 'blog' ); ?>
		</a>
		<?php wpex_overlay( 'outside_link', $overlay ); ?>
	</div>

<?php endif; ?>