( function( $ ) {
	'use strict';

	function wcQuantityIncrementPrepend() {
		$( 'div.quantity:not(.buttons_added), td.quantity:not(.buttons_added)' ).addClass( 'buttons_added' ).append( '<div class="wpex-quantity-btns"><a href="#" class="plus"><span class="ticon ticon-angle-up"></span></a><a href="#" class="minus"><span class="ticon ticon-angle-down"></span></a></div>' );
	} wcQuantityIncrementPrepend();

	$( document ).on( 'click', '.plus, .minus', function() {

		// Get values
		var $qty		= $( this ).closest( '.quantity' ).find( '.qty' ),
			currentVal	= parseFloat( $qty.val() ),
			max			= parseFloat( $qty.attr( 'max' ) ),
			min			= parseFloat( $qty.attr( 'min' ) ),
			step		= $qty.attr( 'step' );

		// Format values
		if ( ! currentVal || currentVal === '' || currentVal === 'NaN' ) {
			currentVal = 0;
		}

		if ( max === '' || max === 'NaN' ) {
			max = '';
		}

		if ( min === '' || min === 'NaN' ) {
			min = 0;
		}

		if ( step === 'any' || step === '' || step === undefined || parseFloat( step ) === 'NaN' ) {
			step = 1;
		}

		// Change the value
		if ( $( this ).is( '.plus' ) ) {

			if ( max && ( max == currentVal || currentVal > max ) ) {
				$qty.val( max );
			} else {
				$qty.val( currentVal + parseFloat( step ) );
			}

		} else {

			if ( min && ( min == currentVal || currentVal < min ) ) {
				$qty.val( min );
			} else if ( currentVal > 0 ) {
				$qty.val( currentVal - parseFloat( step ) );
			}

		}

		// Trigger change event
		$qty.trigger( 'change' );

		return false;

	} );

	// Run on cart update
	$( document.body ).on( 'updated_wc_div wc_update_cart cart_page_refreshed init_checkout updated_checkout', function( event ) {
		wcQuantityIncrementPrepend();
	} );

} ( jQuery ) );